// generate-password.js
// Skripta za generiranje bcrypt hash-a lozinke

const bcrypt = require('bcrypt');
const readline = require('readline');

const rl = readline.createInterface({
  input: process.stdin,
  output: process.stdout
});

console.log('╔════════════════════════════════════════╗');
console.log('║  TapTap Card - Generator Lozinke      ║');
console.log('╚════════════════════════════════════════╝\n');

rl.question('Upiši novu lozinku: ', async (password) => {
  if (!password || password.length < 6) {
    console.log('\n❌ Lozinka mora imati barem 6 znakova!');
    rl.close();
    return;
  }

  try {
    const hash = await bcrypt.hash(password, 10);
    
    console.log('\n✅ Hash generiran!\n');
    console.log('Kopiraj ovaj hash:');
    console.log('═'.repeat(80));
    console.log(hash);
    console.log('═'.repeat(80));
    console.log('\nSQL za ažuriranje:\n');
    console.log(`UPDATE admin_users SET password = '${hash}' WHERE username = 'admin';`);
    console.log('\n');
  } catch (error) {
    console.log('\n❌ Greška:', error.message);
  }
  
  rl.close();
});

// Pokreni: node generate-password.js