<?php
// admin-redirect-test.php

echo "<h1>REDIRECT TEST</h1><hr>";

// 1. Provjeri da li admin.php postoji
if (file_exists('admin.php')) {
    echo "✅ admin.php EXISTS<br>";
    
    // 2. Pročitaj prvih 50 linija
    $content = file_get_contents('admin.php');
    
    // 3. Traži "Location:" redirect
    if (strpos($content, 'Location:') !== false) {
        echo "🔴 <strong>PRONAŠAO REDIRECT u admin.php!</strong><br><br>";
        
        // Izvuci liniju sa Location:
        $lines = explode("\n", $content);
        foreach ($lines as $num => $line) {
            if (stripos($line, 'location:') !== false) {
                echo "Linija " . ($num + 1) . ": <code>" . htmlspecialchars($line) . "</code><br>";
            }
        }
    } else {
        echo "✅ Nema 'Location:' redirect u admin.php<br>";
    }
    
    // 4. Traži "user-login"
    if (stripos($content, 'user-login') !== false) {
        echo "<br>🔴 <strong>PRONAŠAO 'user-login' u admin.php!</strong><br><br>";
        
        $lines = explode("\n", $content);
        foreach ($lines as $num => $line) {
            if (stripos($line, 'user-login') !== false) {
                echo "Linija " . ($num + 1) . ": <code>" . htmlspecialchars($line) . "</code><br>";
            }
        }
    } else {
        echo "✅ Nema 'user-login' reference u admin.php<br>";
    }
    
} else {
    echo "❌ admin.php NE POSTOJI!<br>";
}

echo "<hr>";
echo "<h2>PHP GET Variables:</h2>";
echo "<pre>";
print_r($_GET);
echo "</pre>";

echo "<h2>PHP SERVER Variables:</h2>";
echo "REQUEST_URI: " . $_SERVER['REQUEST_URI'] . "<br>";
echo "SCRIPT_NAME: " . $_SERVER['SCRIPT_NAME'] . "<br>";
echo "PHP_SELF: " . $_SERVER['PHP_SELF'] . "<br>";

echo "<hr>";
echo "<p><a href='/admin.php'>Pokušaj otvoriti /admin.php</a></p>";
echo "<p><a href='/admin'>Pokušaj otvoriti /admin</a></p>";
?>
