<?php
require_once 'config.php';

$request_uri = $_SERVER['REQUEST_URI'];
$path = parse_url($request_uri, PHP_URL_PATH);
$path = trim($path, '/');

if ($path === 'admin' || $path === 'admin.php') {
    header('Location: /admin.php');
    exit;
}

if (strpos($path, 'api/') === 0) {
    include 'api.php';
    exit;
}

$slug = $path ?: null;
if (!$slug) {
    ?>
    <!DOCTYPE html>
    <html lang="hr">
    <head>
        <meta charset="UTF-8">
        <title>TapTap Card</title>
        <style>
            body { 
                font-family: -apple-system, sans-serif; 
                display: flex; 
                align-items: center; 
                justify-content: center; 
                min-height: 100vh; 
                margin: 0; 
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            }
            .box { 
                background: white; 
                padding: 50px; 
                border-radius: 16px; 
                box-shadow: 0 20px 60px rgba(0,0,0,0.3); 
                text-align: center; 
            }
            h1 { color: #333; margin-bottom: 20px; }
            a { 
                display: inline-block; 
                margin: 10px; 
                padding: 12px 24px; 
                background: #667eea; 
                color: white; 
                text-decoration: none; 
                border-radius: 8px; 
                font-weight: 600;
            }
            a:hover { background: #5568d3; }
        </style>
    </head>
    <body>
        <div class="box">
            <h1>🎴 TapTap Card</h1>
            <p>Digital Business Cards Platform</p>
            <div>
                <a href="/admin">Admin Panel</a>
                <a href="/user-login.php">Prijava korisnika</a>
            </div>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Provjeri je li ovo analytics login endpoint
$analyticsSlug = getPlatformSetting('analytics_slug', 'analitika');
if ($slug === $analyticsSlug) {
    include 'analytics-login.php';
    exit;
}

$db = getDB();
$stmt = $db->prepare('SELECT * FROM users WHERE slug = ?');
$stmt->execute([$slug]);
$user = $stmt->fetch();

if (!$user) die('Korisnik nije pronađen');

$stmt = $db->prepare('SELECT * FROM links WHERE user_id = ? ORDER BY sort_order');
$stmt->execute([$user['id']]);
$links = $stmt->fetchAll();

$stmt = $db->prepare('SELECT * FROM modules WHERE user_id = ? AND aktivan = 1');
$stmt->execute([$user['id']]);
$modules = $stmt->fetchAll();

$activeModules = [];
foreach ($modules as $module) {
    $activeModules[$module['modul_name']] = $module;
}

// Log visit
$ip = getUserIP();
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$qrScan = isset($_GET['qr']) && $_GET['qr'] == '1' ? 1 : 0;
$stmt = $db->prepare('INSERT INTO visits (user_id, ip, user_agent, qr_scan) VALUES (?, ?, ?, ?)');
$stmt->execute([$user['id'], $ip, $userAgent, $qrScan]);

// Učitaj odabrani template
$template = $user['display_template'] ?? 'modern';

if ($template === 'business') {
    include 'template-business.php';
} else {
    include 'template-modern.php';
}
?>
