<!DOCTYPE html>
<html lang="hr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nova lozinka - TapTap Card</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            padding: 40px;
            max-width: 400px;
            width: 100%;
        }
        h1 { text-align: center; color: #333; margin-bottom: 10px; font-size: 28px; }
        .subtitle { text-align: center; color: #666; margin-bottom: 30px; font-size: 14px; }
        .form-group { margin-bottom: 20px; position: relative; }
        label { display: block; margin-bottom: 5px; color: #333; font-weight: 500; font-size: 14px; }
        input[type="password"],
        input[type="text"] {
            width: 100%;
            padding: 12px 45px 12px 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
        }
        input:focus { outline: none; border-color: #667eea; }
        .toggle-btn {
            position: absolute;
            right: 10px;
            top: 38px;
            background: none;
            border: none;
            cursor: pointer;
            font-size: 20px;
            padding: 5px 10px;
        }
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
        }
        .error { background: #fee; color: #c33; padding: 12px; border-radius: 8px; margin-bottom: 20px; text-align: center; }
        .success { background: #efe; color: #3c3; padding: 12px; border-radius: 8px; margin-bottom: 20px; text-align: center; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Nova lozinka</h1>
        <p class="subtitle">Unesite novu lozinku</p>
        
        <div id="message"></div>
        
        <form id="resetForm">
            <div class="form-group">
                <label for="password">Nova lozinka</label>
                <input type="password" id="password" required minlength="6">
                <button type="button" class="toggle-btn" onclick="togglePassword('password', this)">👁️</button>
            </div>
            <div class="form-group">
                <label for="confirm">Potvrdi lozinku</label>
                <input type="password" id="confirm" required minlength="6">
                <button type="button" class="toggle-btn" onclick="togglePassword('confirm', this)">👁️</button>
            </div>
            <button type="submit" class="btn">Spremi lozinku</button>
        </form>
    </div>

    <script>
        function togglePassword(fieldId, button) {
            const field = document.getElementById(fieldId);
            if (field.type === 'password') {
                field.type = 'text';
                button.textContent = '🙈';
            } else {
                field.type = 'password';
                button.textContent = '👁️';
            }
        }
        
        const urlParams = new URLSearchParams(window.location.search);
        const token = urlParams.get('token');
        
        if (!token) {
            document.getElementById('message').innerHTML = '<div class="error">Neispravan link</div>';
            document.getElementById('resetForm').style.display = 'none';
        }
        
        document.getElementById('resetForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const password = document.getElementById('password').value;
            const confirm = document.getElementById('confirm').value;
            const messageDiv = document.getElementById('message');
            
            if (password !== confirm) {
                messageDiv.innerHTML = '<div class="error">Lozinke se ne podudaraju</div>';
                return;
            }
            
            try {
                const response = await fetch('/api.php/auth/reset-password', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ token, password })
                });
                
                const data = await response.json();
                
                if (response.ok) {
                    messageDiv.innerHTML = '<div class="success">Lozinka promijenjena! Preusmjeravam...</div>';
                    document.getElementById('resetForm').style.display = 'none';
                    setTimeout(() => window.location.href = 'user-login.php', 2000);
                } else {
                    messageDiv.innerHTML = '<div class="error">' + (data.error || 'Greška') + '</div>';
                }
            } catch (error) {
                messageDiv.innerHTML = '<div class="error">Greška pri povezivanju</div>';
            }
        });
    </script>
</body>
</html>
